/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.view;

import com.ibm.icu.util.ULocale;
import com.mojang.blaze3d.systems.RenderSystem;
import icyllis.modernui.ModernUI;
import icyllis.modernui.animation.Animation;
import icyllis.modernui.core.event.OpenMenuEvent;
import icyllis.modernui.core.forge.ModernUIForge;
import icyllis.modernui.graphics.BlurHandler;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.textmc.ModernFontRenderer;
import icyllis.modernui.graphics.textmc.TextLayoutProcessor;
import icyllis.modernui.math.Point;
import icyllis.modernui.platform.RenderCore;
import icyllis.modernui.test.TestHUD;
import icyllis.modernui.test.TestPauseUI;
import icyllis.modernui.view.DecorView;
import icyllis.modernui.view.DelayedTask;
import icyllis.modernui.view.DragEvent;
import icyllis.modernui.view.IMuiScreen;
import icyllis.modernui.view.MMainScreen;
import icyllis.modernui.view.MMenuScreen;
import icyllis.modernui.view.MeasureSpec;
import icyllis.modernui.view.MotionEvent;
import icyllis.modernui.view.Screen;
import icyllis.modernui.view.UITools;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewParent;
import icyllis.modernui.view.ViewRootImpl;
import icyllis.modernui.widget.FrameLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class UIManager {
    private static UIManager instance;
    public static final Marker MARKER;
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private final ViewRootImpl mAppWindow = new ViewRootImpl(this);
    private final DecorView mDecorView = new DecorView();
    private boolean mCloseScreen;
    @Nullable
    private IMuiScreen mMuiScreen;
    private Screen mScreen;
    private int mWidth;
    private int mHeight;
    private final List<Animation> animations = new ArrayList<Animation>();
    private final List<DelayedTask> tasks = new CopyOnWriteArrayList<DelayedTask>();
    private int mTicks = 0;
    private long mDrawingTimeMillis;
    private Canvas mCanvas;
    @Nullable
    private View mHovered;
    @Nullable
    private View mDragging;
    @Nullable
    private View mKeyboard;
    private double mCursorX;
    private double mCursorY;
    private double mScrollX;
    private double mScrollY;
    boolean mLayoutRequested = false;
    boolean mPendingRepostCursorEvent = false;
    private long mLastLayoutTime = 0L;
    @Nullable
    DragEvent dragEvent;
    View.DragShadow dragShadow;
    Point dragShadowCenter;

    private UIManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)BlurHandler.INSTANCE);
        this.mAppWindow.setView(this.mDecorView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static UIManager getInstance() {
        if (instance != null) return instance;
        Class<UIManager> clazz = UIManager.class;
        synchronized (UIManager.class) {
            if (instance != null) return instance;
            instance = new UIManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void initialize() {
        RenderCore.ensureRenderThread();
        if (UIManager.instance.mCanvas != null) {
            throw new IllegalStateException("Already initialized");
        }
        UIManager.instance.mCanvas = Canvas.getInstance();
    }

    public void openGUI(@Nonnull Screen screen) {
        this.mScreen = screen;
        this.minecraft.func_147108_a((net.minecraft.client.gui.screen.Screen)new MMainScreen(this));
    }

    public void closeGUI() {
        this.minecraft.func_147108_a(null);
    }

    public boolean openGUI(@Nonnull ClientPlayerEntity player, @Nonnull Container menu, @Nonnull String namespace) {
        OpenMenuEvent event = new OpenMenuEvent(menu);
        ModernUIForge.get().post(namespace, event);
        Screen screen = event.getScreen();
        if (screen != null) {
            this.mScreen = screen;
            player.field_71070_bA = menu;
            this.minecraft.func_147108_a(new MMenuScreen<Container>(menu, player.field_71071_by, this));
            return true;
        }
        return false;
    }

    void setContentView(View view, FrameLayout.LayoutParams params) {
        this.mDecorView.removeAllViews();
        this.mDecorView.addView(view, params);
    }

    void start(@Nonnull IMuiScreen screen, int width, int height) {
        if (this.mMuiScreen == null) {
            this.mScreen.window = this;
            this.mScreen.onCreate();
        }
        this.mMuiScreen = screen;
        this.resize(width, height);
    }

    @SubscribeEvent
    void onGuiOpen(@Nonnull GuiOpenEvent event) {
        net.minecraft.client.gui.screen.Screen nextScreen = event.getGui();
        boolean bl = this.mCloseScreen = nextScreen == null;
        if (TestHUD.sDing && !TestHUD.sFirstScreenOpened) {
            this.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187604_bf, (float)1.0f));
            TestHUD.sFirstScreenOpened = true;
        }
        if (this.mCloseScreen) {
            this.stop();
            return;
        }
        if (this.mMuiScreen != nextScreen && nextScreen instanceof IMuiScreen) {
            this.mTicks = 0;
            this.mDrawingTimeMillis = 0L;
        }
        if (this.mMuiScreen != nextScreen && this.mMuiScreen != null) {
            this.onCursorEvent(-1.0, -1.0);
        }
        if (this.mMuiScreen == null) {
            this.mTicks = 0;
            this.mDrawingTimeMillis = 0L;
        }
    }

    public boolean hasOpenGUI() {
        return this.mMuiScreen != null;
    }

    @Nullable
    public Screen getOpenGUI() {
        return this.mScreen;
    }

    public void addAnimation(@Nonnull Animation animation) {
        if (!this.animations.contains(animation)) {
            this.animations.add(animation);
        }
    }

    public void postTask(@Nonnull Runnable runnable, int delayedTicks) {
        if (delayedTicks <= 0) {
            runnable.run();
            return;
        }
        this.tasks.add(new DelayedTask(runnable, delayedTicks));
    }

    void onCursorEvent(double cursorX, double cursorY) {
        this.mCursorX = this.minecraft.field_71417_B.func_198024_e();
        this.mCursorY = this.minecraft.field_71417_B.func_198026_f();
        long now = Util.func_211178_c();
        MotionEvent event = MotionEvent.obtain(now, now, 7, (float)this.mCursorX, (float)this.mCursorY, 0);
        this.mAppWindow.onInputEvent(event);
        this.mPendingRepostCursorEvent = false;
    }

    @SubscribeEvent
    void onRawMouseButton(InputEvent.RawMouseEvent event) {
        if (this.minecraft.field_213279_p == null && this.mMuiScreen != null) {
            ModernUI.LOGGER.debug(MARKER, "Button: {} {} {}", (Object)event.getButton(), (Object)event.getAction(), (Object)event.getMods());
        }
    }

    boolean onScrollEvent() {
        long now = Util.func_211178_c();
        MotionEvent event = MotionEvent.obtain(now, now, 8, (float)this.mCursorX, (float)this.mCursorY, 0);
        event.setRawAxisValue(10, (float)this.mScrollX);
        event.setRawAxisValue(9, (float)this.mScrollY);
        boolean handled = this.mAppWindow.onInputEvent(event);
        if (handled) {
            this.mPendingRepostCursorEvent = true;
        }
        return handled;
    }

    public void onEarlyScrollCallback(double scrollX, double scrollY) {
        this.mScrollX = scrollX;
        this.mScrollY = scrollY;
    }

    public void repostCursorEvent() {
        this.mPendingRepostCursorEvent = true;
    }

    @SubscribeEvent
    void onPostKeyInput(InputEvent.KeyInputEvent event) {
        if (!ModernUIForge.isDeveloperMode() || event.getAction() != 1) {
            return;
        }
        if (!net.minecraft.client.gui.screen.Screen.func_231172_r_()) {
            return;
        }
        switch (event.getKey()) {
            case 82: {
                TextLayoutProcessor.getInstance().reload();
                break;
            }
            case 71: {
                if (this.minecraft.field_71462_r == null && this.minecraft.func_71356_B() && this.minecraft.func_71401_C() != null && !this.minecraft.func_71401_C().func_71344_c()) {
                    this.openGUI(new TestPauseUI());
                }
                this.minecraft.func_135016_M().func_135040_d().forEach(l -> ModernUI.LOGGER.info(MARKER, "Locale {} RTL {}", (Object)l.getCode(), (Object)ULocale.forLocale((Locale)l.getJavaLocale()).isRightToLeft()));
                break;
            }
            case 80: {
                if (this.minecraft.field_71462_r == null) break;
                StringBuilder builder = new StringBuilder();
                builder.append("Modern UI Debug Info:\n");
                builder.append("[0] Mui Screen: ");
                builder.append(this.mMuiScreen != null);
                builder.append("\n");
                builder.append("[1] Container Menu: ");
                builder.append(this.minecraft.field_71439_g != null ? this.minecraft.field_71439_g.field_71070_bA : null);
                builder.append("\n");
                builder.append("[2] Open Gui: ");
                if (this.mScreen == null) {
                    builder.append(this.minecraft.field_71462_r);
                } else {
                    builder.append(this.mScreen);
                }
                builder.append("\n");
                ModernUI.LOGGER.info(MARKER, builder.toString());
            }
        }
    }

    boolean screenKeyDown(int keyCode, int scanCode, int modifiers) {
        ModernUI.LOGGER.debug(MARKER, "KeyDown{keyCode:{}, scanCode:{}, mods:{}}", (Object)keyCode, (Object)scanCode, (Object)modifiers);
        if (this.mKeyboard != null) {
            return this.mKeyboard.onKeyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    boolean screenKeyUp(int keyCode, int scanCode, int modifiers) {
        if (this.mKeyboard != null) {
            return this.mKeyboard.onKeyReleased(keyCode, scanCode, modifiers);
        }
        return false;
    }

    boolean sCharTyped(char codePoint, int modifiers) {
        if (this.mKeyboard != null) {
            return this.mKeyboard.onCharTyped(codePoint, modifiers);
        }
        return false;
    }

    boolean sChangeKeyboard(boolean searchNext) {
        return false;
    }

    boolean onBackPressed() {
        return false;
    }

    void performDrag(int action) {
    }

    void render() {
        MainWindow window = this.minecraft.func_228018_at_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableAlphaTest();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)window.func_198109_k(), (double)window.func_198091_l(), (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
        Paint.take().reset();
        this.mCanvas.setDrawingTime(this.mDrawingTimeMillis);
        this.mAppWindow.onDraw(this.mCanvas);
        GL11.glDisable((int)2848);
        GL11.glLineWidth((float)1.0f);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.matrixMode((int)5889);
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)((double)window.func_198109_k() / window.func_198100_s()), (double)((double)window.func_198091_l() / window.func_198100_s()), (double)0.0, (double)1000.0, (double)3000.0);
        RenderSystem.matrixMode((int)5888);
    }

    @SubscribeEvent
    void onRenderGameOverlay(@Nonnull RenderGameOverlayEvent.Pre event) {
        switch (event.getType()) {
            case CROSSHAIRS: {
                if (this.mMuiScreen == null) break;
                event.setCanceled(true);
                break;
            }
            case ALL: {
                RenderSystem.enableTexture();
                break;
            }
            case HEALTH: {
                if (!TestHUD.sBars) break;
                TestHUD.sInstance.drawBars(this.mCanvas);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    void onRenderTooltip(@Nonnull RenderTooltipEvent.Pre event) {
        if (TestHUD.sTooltip) {
            if (!(this.minecraft.field_71466_p instanceof ModernFontRenderer)) {
                ModernUI.LOGGER.fatal(MARKER, "Failed to hook FontRenderer, tooltip disabled");
                TestHUD.sTooltip = false;
                return;
            }
            MainWindow window = this.minecraft.func_228018_at_();
            double cursorX = this.minecraft.field_71417_B.func_198024_e() * (double)window.func_198107_o() / (double)window.func_198105_m();
            double cursorY = this.minecraft.field_71417_B.func_198026_f() * (double)window.func_198087_p() / (double)window.func_198083_n();
            TestHUD.sInstance.drawTooltip(this.mCanvas, event.getLines(), (ModernFontRenderer)this.minecraft.field_71466_p, event.getStack(), event.getMatrixStack(), event.getX(), event.getY(), (float)cursorX, (float)cursorY, event.getScreenWidth(), event.getScreenHeight());
            event.setCanceled(true);
        }
    }

    void resize(int width, int height) {
        MainWindow window = this.minecraft.func_228018_at_();
        this.mWidth = window.func_198109_k();
        this.mHeight = window.func_198091_l();
        this.mCursorX = this.minecraft.field_71417_B.func_198024_e();
        this.mCursorY = this.minecraft.field_71417_B.func_198026_f();
        this.doLayout();
    }

    private void doLayout() {
        long startTime = Util.func_211178_c();
        int widthSpec = MeasureSpec.makeMeasureSpec(this.mWidth, MeasureSpec.Mode.EXACTLY);
        int heightSpec = MeasureSpec.makeMeasureSpec(this.mHeight, MeasureSpec.Mode.EXACTLY);
        this.mAppWindow.performLayout(widthSpec, heightSpec);
        if (ModernUIForge.isDeveloperMode()) {
            ModernUI.LOGGER.info(MARKER, "Layout done in {} \u03bcs, framebuffer size: {}x{}, cursor pos: ({}, {})", (Object)Float.valueOf((float)(Util.func_211178_c() - startTime) / 1000.0f), (Object)this.mWidth, (Object)this.mHeight, (Object)this.mCursorX, (Object)this.mCursorY);
        }
        this.onCursorEvent(this.mCursorX, this.mCursorY);
        this.mLayoutRequested = false;
    }

    void stop() {
        if (this.mCloseScreen) {
            this.animations.clear();
            this.tasks.clear();
            this.mMuiScreen = null;
            if (this.mScreen != null) {
                this.mScreen.window = null;
                this.mScreen = null;
            }
            this.mLastLayoutTime = 0L;
            this.mLayoutRequested = false;
            this.mDecorView.removeAllViews();
            UITools.useDefaultCursor();
            this.minecraft.field_195559_v.func_197967_a(false);
        }
    }

    @SubscribeEvent
    void onClientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++this.mTicks;
            this.mAppWindow.tick(this.mTicks);
            if (!this.tasks.isEmpty()) {
                Iterator<DelayedTask> iterator = this.tasks.iterator();
                while (iterator.hasNext()) {
                    DelayedTask task = iterator.next();
                    task.tick(this.mTicks);
                    if (!task.shouldRemove()) continue;
                    iterator.remove();
                }
            }
        } else if (this.mPendingRepostCursorEvent) {
            this.onCursorEvent(this.mCursorX, this.mCursorY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    void onRenderTick(@Nonnull TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.mDrawingTimeMillis += (long)((double)this.minecraft.func_193989_ak() * 50.0);
            for (Animation animation : this.animations) {
                animation.update(this.mDrawingTimeMillis);
            }
            BlurHandler.INSTANCE.update(this.mDrawingTimeMillis);
        } else {
            if (!this.animations.isEmpty()) {
                this.animations.removeIf(Animation::shouldRemove);
            }
            if (this.mLayoutRequested && this.mDrawingTimeMillis - this.mLastLayoutTime >= 25L) {
                this.mLastLayoutTime = this.mDrawingTimeMillis;
                this.doLayout();
            }
        }
    }

    public long getDrawingTime() {
        return this.mDrawingTimeMillis;
    }

    public int getElapsedTicks() {
        return this.mTicks;
    }

    public int getScreenWidth() {
        return this.mWidth;
    }

    public int getScreenHeight() {
        return this.mHeight;
    }

    public double getCursorX() {
        return this.mCursorX;
    }

    public double getCursorY() {
        return this.mCursorY;
    }

    public double getViewMouseX(@Nonnull View view) {
        double mouseX = this.mCursorX;
        for (ViewParent parent = view.getParent(); parent != null; parent = parent.getParent()) {
            mouseX += (double)parent.getScrollX();
        }
        return mouseX;
    }

    public double getViewMouseY(@Nonnull View view) {
        double mouseY = this.mCursorY;
        for (ViewParent parent = view.getParent(); parent != null; parent = parent.getParent()) {
            mouseY += (double)parent.getScrollY();
        }
        return mouseY;
    }

    public double getGuiScale() {
        return this.minecraft.func_228018_at_().func_198100_s();
    }

    void setHovered(@Nullable View view) {
        this.mHovered = view;
    }

    @Nullable
    public View getHovered() {
        return this.mHovered;
    }

    public void setDragging(@Nullable View view) {
        if (this.mDragging != view) {
            if (this.mDragging != null) {
                this.mDragging.onStopDragging();
            }
            this.mDragging = view;
            if (this.mDragging != null) {
                this.mDragging.onStartDragging();
            }
        }
    }

    @Nullable
    public View getDragging() {
        return this.mDragging;
    }

    public void setKeyboard(@Nullable View view) {
        if (this.mKeyboard != view) {
            this.minecraft.field_195559_v.func_197967_a(view != null);
            if (this.mKeyboard != null) {
                this.mKeyboard.onStopKeyboard();
            }
            this.mKeyboard = view;
            if (this.mKeyboard != null) {
                this.mKeyboard.onStartKeyboard();
            }
        }
    }

    @Nullable
    public View getKeyboard() {
        return this.mKeyboard;
    }

    static {
        MARKER = MarkerManager.getMarker((String)"UIManager");
    }
}

